unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMObj, MMACMDlg, StdCtrls, MMSystem, MMPCMSup, MMACM, MMRegs, MMDSPObj,
  MMWavIn;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ACM: TMMACM;
    WaveIn: TMMWaveIn;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.Button1Click(Sender: TObject);
var
   wfxSrc: TWaveFormatEx;
   wfxDst: TWaveFormatEx;
   dwSuggest: Longint;
begin
   // build a source PCM format
   pcmBuildWaveHeader(@wfxSrc,16,2,44100);

   // now duplicate it as dest MP3 format
   pcmBuildWaveHeader(@wfxDst,16,2,44100);
   wfxDst.wFormatTAG := WAVE_FORMAT_MPEG_LAYER3;

   // now let the ACM suggest us a MP3 format for this PCM format
   dwSuggest := ACM_FORMATSUGGESTF_NCHANNELS or
                ACM_FORMATSUGGESTF_NSAMPLESPERSEC or
                ACM_FORMATSUGGESTF_WFORMATTAG;

   ACM.PWaveFormat := @wfxDst;

   // now let the ACM suggest a format
   ACM.SuggestFormat(@wfxSrc,dwSuggest);
   if ACM.SuggestFormat(@wfxSrc, dwSuggest) then
   begin
      // now we have a valid MP3 format header and can use it
      WaveIn.PWaveFormat := ACM.PWaveFormat;

      // now a short test if we could record
      WaveIn.DeviceID := -1;
      WaveIn.Start;
      WaveIn.Close;
   end;
end;

end.
